<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );

// Custom
add_filter('wpseo_breadcrumb_output', 'remove_yoast_breadcrumbs_on_homepage', 10, 1);
function remove_yoast_breadcrumbs_on_homepage($output) {
    if (is_front_page() || is_home() || is_404()) {
        return ''; // Hide breadcrumbs on homepage and 404 page
    }
    return $output;
}

add_filter('wpseo_breadcrumb_single_link', 'replace_home_breadcrumb_with_icon', 10, 2);

function replace_home_breadcrumb_with_icon($link_output, $link) {
    // Define an array to map text to Font Awesome icons
    $icon_map = [
        'fa-home'   => 'fas fa-home',
        'fa-futbol' => 'fas fa-futbol',
        'fa-trophy' => 'fas fa-trophy',
        'fa-star'   => 'fas fa-star',
        'fa-users'  => 'fas fa-users',
		'fa-train'  => 'fas fa-train',
    ];

    // Check if the link text exists in our icon map
    if (isset($icon_map[$link['text']])) {
        $icon_class = $icon_map[$link['text']];
        $icon = '<i class="' . esc_attr($icon_class) . '"></i>';

        // Keep the link if there's a URL
        if (!empty($link['url'])) {
            return '<a href="' . esc_url($link['url']) . '">' . $icon . '</a>';
        } else {
            return $icon;
        }
    }

    // If no match, return the original link output
    return $link_output;
}

add_filter('wpseo_breadcrumb_links', 'custom_wpseo_breadcrumb_modifications');
function custom_wpseo_breadcrumb_modifications($links) {

    // Add custom breadcrumb for 'age' taxonomy archives
    if (is_tax('age')) {
        $new_breadcrumb = array(
            'url' => '/omladinska-skola/',
            'text' => 'Omladinska škola',
        );
        array_splice($links, 1, 0, array($new_breadcrumb));
    }

    // Remove player archive link for single 'player' post
    if (is_singular('player')) {
        foreach ($links as $key => $link) {
            if (isset($link['url']) && strpos($link['url'], '/players/') !== false) {
                unset($links[$key]);
            }
        }
        // Reindex the array
        $links = array_values($links);
    }

    return $links;
}

// Trophy v2.0
function render_trophy_card_shortcode($atts) {
    $atts = shortcode_atts(array(
        'title' => 'Priznanja i uspesi',
        'entries' => ''
    ), $atts);

    $entries_raw = explode(',', $atts['entries']);
    $entries = [];
    foreach ($entries_raw as $entry_raw) {
        $entry = trim($entry_raw);
        $last_hyphen_pos = strrpos($entry, '-');

        if ($last_hyphen_pos !== false) {
            $place = substr($entry, 0, $last_hyphen_pos);
            $year = substr($entry, $last_hyphen_pos + 1);
            $entries[] = array('place' => trim($place), 'year' => trim($year));
        }
    }

    ob_start();
    ?>
    <div class="trophy-card">
        <h2><?php echo esc_html($atts['title']); ?></h2>
        <ul class="trophy-list">
            <?php foreach ($entries as $entry):
                $place_raw = $entry['place'];
                $year = esc_html($entry['year']);

                $label = '';
                $is_numeric_place = is_numeric($place_raw);

                if ($is_numeric_place) {
                    $place_number = intval($place_raw);
                } else {
                    $label = esc_html($place_raw);
                }
            ?>
                <li class="trophy-item <?php echo $is_numeric_place ? 'prize-' . $place_number : 'prize-text'; ?>">
                    <?php if ($is_numeric_place): ?>
                        <span class="trophy-icon">
                            <i class="fa fa-trophy"></i>
                            <span class="prize-number"><?php echo $place_number; ?></span>
                        </span>
                        <span><?php echo $year; ?></span>
                    <?php endif; ?>
                    <?php if ($label): ?>
                        <span class="trophy-icon">
                            <i class="fa fa-futbol"></i>
                        </span>
                        <span><?php echo $year; ?></span>
                        <span class="trophy-label"><?php echo $label; ?></span>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php
    return ob_get_clean();
}

add_shortcode('trophy_card', 'render_trophy_card_shortcode');
// Trophy End

// shortcode for the full copyright line
function custom_full_copyright_shortcode() {
    $year = date('Y');
    $site_name = get_bloginfo('name');
    return '<span style="color: var(--e-global-color-fd26097);">&copy; ' . $year . ' ' . $site_name . '</span>';
}
add_shortcode('full_copyright', 'custom_full_copyright_shortcode');

function custom_rest_batch_size() {
    return 50;
}
add_filter( 'rest_get_max_batch_size', 'custom_rest_batch_size' );