<?php
/**
 * API Football Widgets
 * Handles WordPress widget functionality
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class ApiFootballWidgets {
    
    public function __construct() {
        add_action('widgets_init', array($this, 'registerWidgets'));
        add_action('wp_footer', array($this, 'addColorSchemeClass'));
    }
    
    /**
     * Register widgets (placeholder for future widget implementation)
     */
    public function registerWidgets() {
        // Future: Register actual WordPress widgets here
        // For now, we're focusing on shortcodes
    }
    
    /**
     * Add custom colors to frontend
     */
    public function addColorSchemeClass() {
        $options = get_option('api_football_options', array());
        $primary_color = isset($options['primary_color']) ? $options['primary_color'] : '#4A90E2';
        $accent_color = isset($options['accent_color']) ? $options['accent_color'] : '#2196F3';
        
        // Add custom CSS for color scheme
        echo '<style id="api-football-custom-colors">
            .api-football-table thead {
                background: ' . esc_attr($primary_color) . ' !important;
            }
            .position-europe {
                border-left-color: ' . esc_attr($accent_color) . ' !important;
            }
            .api-football-widget:hover {
                box-shadow: 0 4px 12px rgba(' . $this->hexToRgb($primary_color) . ', 0.15) !important;
            }
            .fixture-item:hover {
                background-color: rgba(' . $this->hexToRgb($accent_color) . ', 0.05) !important;
            }
        </style>';
    }
    
    /**
     * Convert hex color to RGB values
     */
    private function hexToRgb($hex) {
        $hex = ltrim($hex, '#');
        if (strlen($hex) == 6) {
            return hexdec(substr($hex, 0, 2)) . ', ' . hexdec(substr($hex, 2, 2)) . ', ' . hexdec(substr($hex, 4, 2));
        }
        return '74, 144, 226'; // fallback blue
    }
}

/**
 * Future WordPress Widget Class Template
 * Uncomment and modify when implementing actual widgets
 */

/*
class ApiFootball_Standings_Widget extends WP_Widget {
    
    public function __construct() {
        parent::__construct(
            'api_football_standings',
            __('API Football Standings', 'api-football'),
            array('description' => __('Display league standings table', 'api-football'))
        );
    }
    
    public function widget($args, $instance) {
        echo $args['before_widget'];
        
        if (!empty($instance['title'])) {
            echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        }
        
        $shortcode = new ApiFootballShortcodes();
        $atts = array(
            'league' => !empty($instance['league']) ? $instance['league'] : '',
            'season' => !empty($instance['season']) ? $instance['season'] : '',
            'limit' => !empty($instance['limit']) ? $instance['limit'] : '10'
        );
        
        echo $shortcode->standingsShortcode($atts);
        
        echo $args['after_widget'];
    }
    
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : __('League Standings', 'api-football');
        $league = !empty($instance['league']) ? $instance['league'] : '';
        $season = !empty($instance['season']) ? $instance['season'] : '';
        $limit = !empty($instance['limit']) ? $instance['limit'] : '10';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:', 'api-football'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('league')); ?>"><?php _e('League ID:', 'api-football'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('league')); ?>" name="<?php echo esc_attr($this->get_field_name('league')); ?>" type="number" value="<?php echo esc_attr($league); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('season')); ?>"><?php _e('Season:', 'api-football'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('season')); ?>" name="<?php echo esc_attr($this->get_field_name('season')); ?>" type="number" value="<?php echo esc_attr($season); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('limit')); ?>"><?php _e('Number of teams:', 'api-football'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('limit')); ?>" name="<?php echo esc_attr($this->get_field_name('limit')); ?>" type="number" value="<?php echo esc_attr($limit); ?>" min="1" max="50">
        </p>
        <?php
    }
    
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['league'] = (!empty($new_instance['league'])) ? absint($new_instance['league']) : '';
        $instance['season'] = (!empty($new_instance['season'])) ? absint($new_instance['season']) : '';
        $instance['limit'] = (!empty($new_instance['limit'])) ? absint($new_instance['limit']) : '10';
        
        return $instance;
    }
}
*/ 