/**
 * API Football Admin Scripts
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        // Initialize admin functionality
        initAdminFeatures();
    });
    
    function initAdminFeatures() {
        // Initialize WordPress color pickers
        $('.api-football-color-picker').wpColorPicker();
        
        // Copy shortcode to clipboard functionality
        $('.api-football-shortcodes code').on('click', function() {
            var $this = $(this);
            var text = $this.text();
            
            // Create temporary textarea to copy text
            var $temp = $('<textarea>');
            $('body').append($temp);
            $temp.val(text).select();
            
            try {
                document.execCommand('copy');
                
                // Show success feedback
                var originalText = $this.text();
                $this.text('Copied!').addClass('copied');
                
                setTimeout(function() {
                    $this.text(originalText).removeClass('copied');
                }, 2000);
                
            } catch (err) {
                console.log('Copy failed');
            }
            
            $temp.remove();
        });
        
        // Add hover effect for shortcodes
        $('.api-football-shortcodes code').on('mouseenter', function() {
            $(this).attr('title', 'Click to copy');
        });
    }
    
})(jQuery);

// Add CSS for admin features
if (!document.querySelector('style[data-api-football-admin]')) {
    var style = document.createElement('style');
    style.setAttribute('data-api-football-admin', '');
    style.textContent = `
        .api-football-shortcodes code {
            cursor: pointer;
            transition: all 0.2s ease;
        }
        .api-football-shortcodes code:hover {
            background-color: #e3f2fd;
            border-color: #2196f3;
        }
        .api-football-shortcodes code.copied {
            background-color: #e8f5e8;
            border-color: #4caf50;
            color: #4caf50;
        }
    `;
    document.head.appendChild(style);
} 